/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.soundscool.network.packet;

import com.dynious.soundscool.handler.DelayedPlayHandler;
import com.dynious.soundscool.handler.NetworkHandler;
import com.dynious.soundscool.handler.SoundHandler;
import com.dynious.soundscool.helper.NetworkHelper;
import com.dynious.soundscool.network.packet.IPacket;
import com.dynious.soundscool.network.packet.server.SoundReceivedPacket;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class SoundUploadedPacket
implements IPacket {
    String category;
    String soundName;

    public SoundUploadedPacket() {
    }

    public SoundUploadedPacket(String soundName, String category) {
        this.category = category;
        this.soundName = soundName;
    }

    @Override
    public void readBytes(ByteBuf bytes) {
        int catLength = bytes.readInt();
        char[] catCars = new char[catLength];
        for (int i = 0; i < catLength; ++i) {
            catCars[i] = bytes.readChar();
        }
        this.category = String.valueOf(catCars);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && (this.category.equalsIgnoreCase("null") || this.category.isEmpty())) {
            this.category = Minecraft.func_71410_x().func_147104_D().field_78847_a;
        }
        int fileLength = bytes.readInt();
        char[] fileCars = new char[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileCars[i] = bytes.readChar();
        }
        this.soundName = String.valueOf(fileCars);
        File soundFile = NetworkHelper.createFileFromByteArr(NetworkHandler.soundUploaded(this.soundName), this.category, this.soundName);
        SoundHandler.addLocalSound(this.soundName, soundFile);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            DelayedPlayHandler.onSoundReceived(this.soundName);
        } else {
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(this.category);
            if (player != null) {
                NetworkHelper.sendPacketToPlayer(new SoundReceivedPacket(SoundHandler.getSound(this.soundName)), (EntityPlayer)player);
            }
        }
    }

    @Override
    public void writeBytes(ByteBuf bytes) {
        bytes.writeInt(this.category.length());
        for (char c : this.category.toCharArray()) {
            bytes.writeChar((int)c);
        }
        bytes.writeInt(this.soundName.length());
        for (char c : this.soundName.toCharArray()) {
            bytes.writeChar((int)c);
        }
    }
}

